﻿using System.Collections.Generic;
using System.Linq;
using Caliburn.Micro;
using FDOT.GIS.Framework.Examples.ContentService;
using FDOT.GIS.Client.Commands;
using FDOT.GIS.Client.Core;
using FDOT.GIS.Client;
using FDOT.GIS.Client.Domain;
using System.ServiceModel;
using System.ComponentModel.Composition;

namespace FDOT.GIS.Framework.Examples.Commands
{
    public class GetContent : ResultBase
    {
        private List<string> _keys = new List<string>();

        internal string ServicePath { get; set; }

        private ContentServiceClient _contentServiceClient = null;
        private ContentServiceClient ContentServiceClient
        {
            get
            {
                if (_contentServiceClient == null)
                {
                    // only registered clients can be created
                    Log.Info("Registering ContentServiceClient.");
                    ServiceClients.RegisterClient(typeof(IContentService), typeof(ContentServiceClient));                           

                    // Get a configured service client instance
                    // The true flag in the call to GetClient indicates that we're using a service path relative to the root of the web
                    // serving the Silverlight app.  If using an absolute path, GetClient(servicePath) will suffice as the default is
                    // to use an absolute path.
                    Log.Info("Creating ContentServiceClient instance using service path [{0}].", ServicePath);
                    _contentServiceClient = ServiceClients.GetClient<IContentService>(ServicePath, true) as ContentServiceClient;  
                }
                return _contentServiceClient;
            }
        }


        public GetContent(string key) : this(new[] { key }) { }

        public GetContent(IEnumerable<string> keys)
        { 
            _keys.AddRange(keys);
        }

        public Dictionary<string, string> Result { get; private set; }

        public override void Execute(ActionExecutionContext context)
        {
            Log.Info("GetContentCommand executed for keys: " + string.Join(", ", _keys.ToArray()));
            if (_keys.Any())
            {
                Log.Info("ContentServiceClient path resolved to [{0}].", ContentServiceClient.Endpoint.Address.Uri.ToString());
                ContentServiceClient.GetContentCompleted += GetContentCompleted;                // attach the completed callback
                Log.Info("Calling ContentServiceClient ...");
                ContentServiceClient.GetContentAsync(new ObservableCollection<string>(_keys));  // call the service
            }
        }

        /// <summary>
        /// Callback for the service.
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void GetContentCompleted(object sender, GetContentCompletedEventArgs e)
        {
            Log.Info("GetContentCommnad completed with result: " + string.Join(", ", e.Result.Values));
            if (e.Result != null) Result = e.Result;
            Success();
        }
    }
}
