﻿using System.Windows;
using FDOT.GIS.Client.Domain;
using FDOT.GIS.Client.ViewModels;

namespace FDOT.GIS.Framework.Examples.ViewModels
{
    [DisplayName("Dialog Created From Attributes Example")]
    public class MyComponentSettingsViewModel : SettingsViewModel
    {
        private static MyComponentSettingsViewModel _viewModel = new MyComponentSettingsViewModel();

        private MyComponentSettingsViewModel()
        {
            DialogServiceArgs.Id = "mycomponentsettingsviewmodel";
            DialogServiceArgs.Title = "My Component Settings";
        }

        [Hidden]
        public static MyComponentSettingsViewModel Instance
        {
            get { return _viewModel; }
        }


        [Hidden]
        [DisplayName("")]
        public string TextMessage
        {
            get
            {
                return "This example uses the LayoutManager to build a view based on\n" +
                        "a viewmodel with custom attributes that describe how the\n" +
                        "viewmodel should be rendered.  It can also be used to invoke\n" +
                        "actions.";
            }
        }


        [SwitchButton]
        [DisplayName("Switch Button")]
        [ToolTipText("Sets a boolean property and persists it to Silverlight Isolated Storage")]
        public bool MyBoolProperty
        {
            get { return LoadSetting<bool>("MyBoolProperty"); }
            set
            {
                SaveSetting("MyBoolProperty", value);
                NotifyOfPropertyChange(() => MyBoolProperty);
            }
        }


        [ActionAttribute]
        [DisplayName("Do Something Now")]
        public void DoSomething()
        {
            MessageBox.Show("Can invoke an action here.");
        }
    }
}
