﻿using System.ComponentModel.Composition;

using FDOT.GIS.Client.Controls;
using FDOT.GIS.Client.Domain;
using FDOT.GIS.Client.ViewModels;


namespace FDOT.GIS.Framework.Examples.ViewModels
{
    [Export]
    [PartCreationPolicy(CreationPolicy.Shared)]
    [DisplayName("Query By Address Settings")]
    public class QueryByAddressSettingsViewModel : SettingsViewModel
    {
        private static QueryByAddressSettingsViewModel _viewModel = new QueryByAddressSettingsViewModel();

        private QueryByAddressSettingsViewModel()
        {
            DialogServiceArgs.Id = "querybyaddresssettings";
            DialogServiceArgs.Title = "Query By Address Settings";
        }

        [Hidden]
        public static QueryByAddressSettingsViewModel Instance
        {
            get { return _viewModel; }
        }


        [Hidden]
        [DisplayName("")]
        public string TextMessage
        {
            get
            {
                 return "Limits the feature types available to those that are currently\n" +
                        "active.  You can change the active feature types using the Map\n" +
                        "Layers component.  Changes to this setting will be reflected the next\n" +
                        "time you open the Query By Address component.";
            }
        }

        [SwitchButton]
        [DisplayName("LimitQueriesToActiveLayers")]
        [ToolTipText("Limits the feature types available to those that are currently active.")]
        public bool LimitQueriesToActiveLayers
        {
            get { return LoadSetting<bool>("LimitQueryByAddressToActiveLayers"); }
            set
            {
                SaveSetting("LimitQueryByAddressToActiveLayers", value);
                NotifyOfPropertyChange(() => LimitQueriesToActiveLayers);
            }
        }
    }
}