﻿using System;
using System.Collections.Generic;
using System.ComponentModel.Composition;
using System.Windows;
using System.Windows.Media;
using Caliburn.Micro;

using FDOT.GIS.Client.Domain;
using FDOT.GIS.Client.Domain.Drawing;
using FDOT.GIS.Client.Domain.Graphics;
using FDOT.GIS.Client.Domain.Measurement;
using FDOT.GIS.Client.Domain.UnitConversion;
using FDOT.GIS.Client.Helpers;
using FDOT.GIS.Client.ViewModels;
using FDOT.GIS.Framework.Examples.Commands;


namespace FDOT.GIS.Framework.Examples.ViewModels
{
    [Export]
    [PartCreationPolicy(CreationPolicy.Shared)]
    [DisplayName("Service Example")]
    public class ServiceExampleViewModel : ComponentBase
    {
        private string _servicePath;

        [Text]
        [DisplayName("")]
        public string TextMessage
        {
            get
            {
                return "This example uses the ContentService to retrieve a value by\n" +
                        "key.  The service itself is intended primarily for testing\n" +
                        "and illustration; however it can be easily extended to support\n" +
                        "more complex scenarios, such as providing canned queries.";
            }
        }


        private string _returnedContent = string.Empty;
        [Text]
        [DisplayName("")]
        public string ReturnedContent
        {
            get { return _returnedContent; }
            set
            {
                _returnedContent = value;
                NotifyOfPropertyChange(() => ReturnedContent);
            }
        }


        [Action]
        [DisplayName("Get Message")]
        public void GetMessage()
        {
            Log.Info("GetMessage called");
            Coroutine.BeginExecute(GetMessageWorkflow().GetEnumerator(), null, null);  
        }


        [Hidden]
        public IEnumerable<IResult> GetMessageWorkflow()
        {
            var getContent = new GetContent("HelloMessage");
            getContent.ServicePath = _servicePath;
            yield return getContent;
            Log.Info("Content returned");
            ReturnedContent = getContent.Result.ContainsKey("HelloMessage") ? getContent.Result["HelloMessage"] : "Unable to retrieve content from the server.";
        }


        #region IComponentBase implementation
        protected override string IconResourceUri
        {
            get { return "/FDOT.GIS.Client;component/Assets/Images/full_extent.png"; }
        }

        protected override void OnInitialize(IDictionary<string, string> customSettings)
        {
            _servicePath = customSettings["servicePath"];
        }


        GenericDialogViewModel _dialogViewModel;
        protected override void OnExecute()
        {
            // A logger is provided via ComponentBase
            Log.Info("Entered {0}.OnExecute().", this.GetType().ToString());

            _dialogViewModel = LayoutManager.Instance.ShowViewModel(this, 
                                          new DialogServiceArgs
                                          {
                                              Id="ServiceExample",
                                              Title = this.ComponentConfiguration.Name,
                                              HelpId = "tools;" + GetType().FullName,
                                              Icon = Icon
                                          });

            _dialogViewModel.Closed += OnClose;
        }


        private void OnClose(object sender, EventArgs e)
        { _dialogViewModel = null; }

        protected override void OnError(ErrorEventArgs errorEventArgs)
        {
            Log.Error(errorEventArgs.Exception);
            MessageBox.Show(errorEventArgs.Exception.ToString());
            errorEventArgs.Handled = true;
        }

        #endregion
    }
}
