﻿using System;
using System.Collections.Generic;
using System.Configuration;
using System.IdentityModel.Services;
using System.Linq;
using System.Security.Claims;
using System.Security.Permissions;
using System.Web;
using System.Web.Mvc;
using System.Web.Security.AntiXss;
using ExampleRelyingParty_UsingClientless.Models;
using ExampleRelyingParty_UsingClientless.Utility;

namespace ExampleRelyingParty_UsingClientless.Controllers
{
    public class HomeController : Controller
    {
        public ActionResult Index()
        {
            // Create a ClaimsPrincipal object from the current user to work with claims
            ClaimsPrincipal claimsPrincipal = HttpContext.User as ClaimsPrincipal;
            ClaimsViewModel claimsViewModel = new ClaimsViewModel();
            if (claimsPrincipal != null)
            {
                var claims = ClaimsMapper.MapClaimsViewModels(claimsPrincipal.Claims);
                claimsViewModel.ClaimsViewModels = claims.ToList();
                /* 
             * We can use the FindFirst method to get the first occurance of a specific claim.
             * This is very useful when you only expect a single instance of a particular claim type.
             * Note the ClaimTypes class contains many common claims defined as properties for your use.
                */
                Claim claimEmail = claimsPrincipal.FindFirst(ClaimTypes.Email);
                Claim claimName = claimsPrincipal.FindFirst(ClaimTypes.Name);
                claimsViewModel.EmailAddress = claimEmail != null
                    ? AntiXssEncoder.HtmlEncode(claimEmail.Value, false)
                    : "Email claim not found";
                claimsViewModel.Name = claimName != null
                    ? AntiXssEncoder.HtmlEncode(claimName.Value, false)
                    : "Name claim not found";
            }
            return View(claimsViewModel);
        }

       
        public ActionResult About()
        {
            ViewBag.Message = "Your application description page.";

            return View();
        }


        [ClaimsPrincipalPermission(SecurityAction.Demand, Operation = "Show", Resource = "Contact")]
        public ActionResult Contact()
        {
            ViewBag.Message = "Your contact page.";

            return View();
        }

        public ActionResult Logout()
        {
            var queryString = Signout();
            return new RedirectResult(queryString);
        }


        private string Signout()
        {
            if (HttpContext.Request.Url != null)
            {
                var authModule = FederatedAuthentication.WSFederationAuthenticationModule;
                authModule.SignOut(false);
                var signOutRequestMessage = new SignOutRequestMessage(new Uri("https://codev1.dot.state.fl.us/fdot.sts/testtoken/issue/"), 
                    ConfigurationManager.AppSettings.Get("ida:Realm"));
                return signOutRequestMessage.WriteQueryString();

            }
            return "";
        }
    }
}