﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Mvc;
using System.Web.Optimization;
using System.Web.Routing;

namespace ExampleRelyingParty_UsingClientless
{
    public class MvcApplication : System.Web.HttpApplication
    {
        /// <summary>
        ///  Identity Config based Application_Start
        /// </summary>
        protected void Application_Start()
        {
            AreaRegistration.RegisterAllAreas();
            FilterConfig.RegisterGlobalFilters(GlobalFilters.Filters);
            RouteConfig.RegisterRoutes(RouteTable.Routes);
            BundleConfig.RegisterBundles(BundleTable.Bundles);
            IdentityConfig.ConfigureIdentity(IdentityConfig.StsConfiguration.devToUnit);
           

        }

        private void Application_BeginRequest(object sender, EventArgs e)
        {
            if (String.Compare(Request.Path, Request.ApplicationPath, StringComparison.InvariantCultureIgnoreCase) == 0 &&
                !Request.Path.EndsWith("/"))
            {
                //  This corrects WIF error ID3206 "A SignInResponse message may only redirect within the current web application: '/NHP' is not allowed."
                //  For whatever reason, accessing the site without a trailing slash causes this error.
                if (!Request.Path.EndsWith("/"))
                {
                    Response.Redirect(string.Concat(Request.Path, "/"));
                }
            }

            switch (Request.Url.Scheme)
            {
                case "https":
                    Response.AddHeader("Strict-Transport-Security", "max-age=300");
                    break;
                case "http":
                    var path = string.Format("https://{0}{1}", Request.Url.Host, Request.Url.PathAndQuery);
                    Response.Status = "301 Moved Permanently";
                    Response.AddHeader("Location", path);
                    break;
            }

        }
    }
}
