﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Security.Claims;
using System.Web;
using ExampleRelyingParty_UsingClientless.Models;

namespace ExampleRelyingParty_UsingClientless.Utility
{
    public static class ClaimsMapper
    {

        #region Constructors

        /// <summary>
        /// Default constructor.
        /// <para>
        /// Configures mappings to copy values from a source object to a destination object.
        /// </para>
        /// </summary>
        static ClaimsMapper()
        {
            AutoMapper.Mapper.CreateMap<Claim, ClaimViewModel>();
        }

        #endregion

        #region Static Methods

        public static ClaimViewModel MapClaimsViewModel(Claim claim)
        {
            if (claim == null) { throw new ArgumentNullException("claim"); }
            return AutoMapper.Mapper.Map<Claim, ClaimViewModel>(claim);
        }

        /// <summary>
        /// Map list of System.Security.Claims.Claim to list of ClaimViewModel 
        /// </summary>
        /// <param name="claims">IEnumerable System.Security.Claims.Claim</param>
        /// <returns>IEnumerable ClaimsViewModels</returns>
        /// <exception cref="ArgumentNullException">
        /// Thrown if <paramref name="claims"/> is <c>null</c>.
        /// </exception>
        public static IEnumerable<ClaimViewModel> MapClaimsViewModels(IEnumerable<Claim> claims)
        {
            if (claims == null) { throw new ArgumentNullException("claims"); }

            return claims.Select(MapClaimsViewModel).ToList();
        }
        #endregion
    }
}